--[[---------------------------------------------------------------------------
	Chocolatier Two Help
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local label = { "#"..GetString("paris") }
table.insert(label, GetString("travel_time", tostring(2)))
table.insert(label, GetString("travel_price", bsgDollars(2 * Simulator.travelCost)))
table.insert(label, GetString("travel_click"))
label = table.concat(label,"<br>")

MakeDialog
{
	name="help_dlg",
	Frame
	{
		x=kCenter,y=kCenter,w=640,h=440,color=DialogColor,
		AnimationWindow
		{
			x=5,y=5,w=kMax-5,h=kMax-5,fps=20,
			HelpTitle(2),
			Bitmap { x=0,y=2, image="control/globe_up", scale=32/68 },
			AppendStyle { font=helpFont, flags=kVAlignCenter+kHAlignLeft },
			Text { x=0,y=40,w=kMax,h=60, label="help2", flags=kVAlignTop+kHAlignLeft },

			Text { x=100,y=90,w=kMax,h=50, label="help2_pinsA", },
			Sprite { x=31+16,y=117, image="image/port_current" },
			Sprite { x=16+32,y=110, image="image/port_available" },
			
			Text { x=100,y=145,w=kMax,h=50, label="help2_pinsB", },
			Sprite { x=16+32,y=165, image="image/port_new.xml" },

			Text { x=100,y=200,w=kMax,h=50, label="help2_factory", },
			Sprite { x=16,y=220, image="image/factory.xml" },
			Sprite { x=68,y=230, image="image/factory_idle.xml" },
			
			Text { x=100,y=260,w=kMax,h=50, label="help2_shoplab", },
			Sprite { x=16,y=280, image="image/icon_shop" },
			Sprite { x=68,y=290, image="image/icon_lab" },
			
			Bitmap { x=0,y=330, image="image/traveltag",
				Text { x=51,y=5,w=kMax-5,h=kMax-5, label=label, font=travelTagFont, flags=kVAlignCenter+kHAlignLeft, } },
			Text { x=220,y=330,w=kMax,h=100, label="help2_travel", },
		}
	}
}
